/****************************************                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          /*********************************
**        GayBlade   Ver 1.0.0         **
**        Programmed by Ryan Best      **
**       Copyright by  Ryan Best 1992 **
*****************************************/
   
#include "Packages.h"
#include "Palettes.h"
#include "Sound.h"
#include "stdlib.h"
#include "stdio.h"
#include "files.h"
#include "OSUtils.h"
#include "QDOffscreen.h"
#include "GB.h"

WindowPtr	gPictureWindow, gGameWindow, gCastleWindow,gIntroWindow,gBackgrndWindow;
Boolean		gDone, gWNEImplemented;
EventRecord	gTheEvent;
typedef		EventRecord	gEventPtr;
MenuHandle	gAppleMenu,gFileMenu,gOptionsMenu,gSpecialMenu;
Rect		gIntroRect, gTavernRect, gBankRect, gRollerRect, gStoreRect, gCharRect0,
			gCharRect1, gCharRect2, gCharRect3,gItemsRect, gMapRect, gSpellsRect,gSrcRect,
			gGuildRect,gHealerRect,gdungeonRect, gStatsRect, gPartyInfoRect,
			gUseRect,gPanicRect, gMoveRect, gDungDispRect, gActionRect,gConsoleRect, 
			gMScreenRect,leftRect,centerRect,rightRect,cLeftRect,cCenterRect,cRightRect,
			doorRect,clwallRect,crwallRect,cRect, gChestRect,gItemRect,gListStatsRect,
			gListItemsRect, gCompassRect,gTreasureRect;
PicHandle	gThePicture, gConsolePicture, gDungeon1, gLeftWall, gCenterWall, gRightWall,
			gLeftDoor,gRightDoor,gFlatWall,gFlatDoor,gOpenSpace,gFarWall,gFarDoor,gCLWall,gCRWall,
			gCOpenSpace,gCLDoor,gCRDoor,gCFWall,gCFDoor, gMScreenPicture,gIntroPic;
CIconHandle	gVialIcon,gShieldIcon, gRingIcon, gSphereIcon,gFlailIcon,gCloakIcon,gArrowIcon,gDaggerIcon,
			gSwordIcon,gHelmetIcon,gTorchIcon,gBookIcon,gGlovesIcon,gBurnedIcon,gArmorIcon,
			gChestIcon, gCompassIcon,gCNorthIcon,gCSouthIcon,gCEastIcon,
			gCWestIcon;
int			gSndOn=0,gPanicOn=0, gInCastle, gPartyNum,gNewChar, gSndNum, gLastChar, gLight,
			gLightSpell,gItemUseScreen, gCurChar, gInPrison,gDialogNum,gDisplay,gDungLevel,gXLoc,gYLoc,
			gView,gResistFire,gResistIce,gPartyInvis,gInEncounter,gCureWho,gFoundItems[3],
			gCreatType, gCreatureCounter, gCreatHits[10],gLevelCount,dmgType,gTreasure=NO,
			gDisarmSpellCast,gCompass,ASave,gMagicItems[4],gSpeed,gCharShields[4],gEvade,
			gItemsOnFloor,gCPUSpeed;
long		gStats[6], gDungParty[4],gWhichChar,glastWhen,gPanic;
Point		glastWhere;
DialogPtr	gCastleDialog;
RGBColor	gNameBack, gStatsBack, gSpecName,gNormName,gMessBack,gBlack,gStatsFore;
CCrsrHandle	gSpellCursor;
SFReply		fileName;

Rect			GlobalDestRect,GlobalSourceRect;/* Temporary rect used for the pict & gworld. */ 
CGrafPtr		GlobalCurrentPort;				/* Port used before switching to the gworld's. */
GDHandle		GlobalCurrentDevice;			/* GDevice used before switching to the gworld's. */
GWorldPtr		GlobalGWorld;					/* Pointer to Gworld */
PixMapHandle	GlobalPixMap;					/* Needed PixMapHandle to lock down.*/		

struct	CharInfo 
{
	Str255	name;
	int		type;
	int		race;
	int		level;
	int		exp;
	int		status;
	int		hits;
	int		dmg;
	int		age;
	int		str;
	int		wis;
	int		itl;
	int		con;
	int		dex;
	int		items[7];	
	int		itemsInUse[7];			/* what items are being used */
	int		gold;
	int	 	bank;					/* released wizard? */
	int		mspells[4],cspells[4];
	int		dngLevel, xLoc, yLoc,Pos;	
};

struct	CharInfo	GameChars[8];			/*  Can store up to 8 chars per game  */

struct	ItemInfo 
{
	Str255			name;
	unsigned char	type;
	unsigned char	status;		/* whether item is in use or not */
	unsigned char	instore;
	unsigned char	level;
	Byte			attrib;
	unsigned char	dmg;
	unsigned char	def;
	unsigned char	con;
};
struct	ItemInfo	GameItems[101];		

struct	DungInfo 				
{
	unsigned int	XY[10][10];		/*  x, y  rooms location */
	unsigned int	N[100];			/* 100 rooms w/north walls */
	unsigned int	S[100];			/* 100 rooms w/south walls */
	unsigned int	E[100];			/* 100 rooms w/east walls */
	unsigned int	W[100];			/* 100 rooms w/west walls */
	unsigned int	SA[100];
};
struct	DungInfo	Dungeon[1];	

struct	CreatureInfo 				/* access database each encounter */
{
	Str255			name;
	unsigned char	type;
	unsigned char	status;		/* For use in editor only */
	unsigned char	instore;	/* Unused variable */
	unsigned char	level;
	Byte			attrib;
	Byte			dmg;
	Byte			def;
	Byte			hits;
};

struct	CreatureInfo	GameCreatures[1];	
					
/********************************** main *****************************/
main()
{
void	AInitSnd(void);
	
	ToolBoxInit();
	IsColor();							/* check to see if Color QD is there */	
	GameIntro();						/* animated intro screen */	
	FlushEvents (everyEvent, REMOVE_ALL_EVENTS);	/* remove key clicks */	
	GetDateTime(&randSeed);				/* randomize using datetme */
	VarInit(); 
	SetupRects();
	MakeGlobalGWorld();					/* create global gworld */		
	ReadFiles();	
	EnterCastle();	 
}
/****************************** EnterCastle *********************/

EnterCastle()
{
	MenuBarInit();
	InitDungeon();	
	GameWindow(); 
	AdjustMenus();
	FlushEvents (everyEvent, REMOVE_ALL_EVENTS);
	MainLoop();
	}

/******************************* VarInit ************************/
VarInit()
{
int	z,x;

	for (z=0;z<=7;z++)
	{
		for (x=0;x<=6;x++)
		  {
			GameChars[z].items[x]=OPENSLOT;			/* items */
			GameChars[z].itemsInUse[x]=OPENSLOT;	/* items in use */
		  }
		GameChars[z].Pos=-1;						/* no chars in position */		  
		GameChars[z].status=99;			  			/* all char / item slots open */
		GameChars[z].dngLevel=-1;					/* dnglevel = castle */		  
	}
			
	for (z=0;z<=3;z++)				/* dungeon party to none */
		gDungParty[z]=99;
		
	for (z=0;z<=2;z++)				/* found items to 0 */
		gFoundItems[z]=-1;	
		


	gDungLevel=-1;					/* in castle */
	gDisarmSpellCast=NO;			/* trapped chest disarm spell */		
	gInCastle=YES;
	gPanic=NO;
	gNewChar =-1;					/* non existent char number  */
	gPartyNum=0;					/* no one in party */
	gCurChar =-1;
	gDisplay=1;						/* screen set to STATS */
	gInEncounter=NO;				/* no active encounter */
	gItemUseScreen=NO;				/* not trying to use any item, yet*/
	gResistFire=OFF;				/* protective spells Off */
	gResistIce=OFF;					/* protective spells Off */
	gPartyInvis=OFF;				/* protective spells Off */
	gLightSpell=OFF;				/* light spell not cast */
	gCureWho=OFF;					/* for cure/raise spells */
	gLevelCount=0;					/* USED FOR READING DATAFILE! 0=level 1 */
	gCompass=OFF;					/* used for compass spell / item */
	ASave=OFF;						/* automatic save is OFF */
	gSpeed=ON;						/* fast as possible */
	
	gNameBack.red=52428;
	gNameBack.blue=39321;
	gNameBack.green=26214;
	
	gStatsBack.red=52428;
	gStatsBack.green=26214;
	gStatsBack.blue=39321;
	
	gStatsFore.red=19670;
	gStatsFore.green=19590;
	gStatsFore.blue=29900;
			
	gBlack.red=0;
	gBlack.green=0;
	gBlack.blue=0;	
	
	gSpecName.red=30720;
	gSpecName.blue=0;
	gSpecName.green=0;
		  
	gNormName.red=0;
	gNormName.blue=33150;
	gNormName.green=0;	
		
	gMessBack.red=39321;		 
	gMessBack.blue=65535;
	gMessBack.green=65535;	  

	gVialIcon=GetCIcon(131);
	gSwordIcon=GetCIcon(501);
	gDaggerIcon=GetCIcon(510);
	gCloakIcon=GetCIcon(540);	
	gShieldIcon=GetCIcon(560);
	gRingIcon=GetCIcon(590);
	gSphereIcon=GetCIcon(610);
	gFlailIcon=GetCIcon(520);
 	gHelmetIcon=GetCIcon(570);	 
	gArrowIcon=GetCIcon(900);
	gTorchIcon=GetCIcon(130);
	gBookIcon=GetCIcon(129);	
	gGlovesIcon=GetCIcon(530);		
	gBurnedIcon=GetCIcon(132);
	gArmorIcon=GetCIcon(550);
	gCompassIcon=GetCIcon(158);		/* normal key */
	gCNorthIcon=GetCIcon(154);		/* north */
	gCSouthIcon=GetCIcon(155);		/* south */	
	gCEastIcon=GetCIcon(156);		/* east */
	gCWestIcon=GetCIcon(157);		/* west */
	

}
/******************************* ToolBoxInit ************************/

ToolBoxInit()
{
	InitGraf (&thePort);
	InitFonts();		
	InitWindows();
	InitMenus();
	TEInit();
	InitDialogs (NIL_POINTER);
	InitCursor();
	FlushEvents (everyEvent, REMOVE_ALL_EVENTS);	
}
/**************************** MakeGlobalGWorld *****************************/

MakeGlobalGWorld()
{
Rect		destRect;			/* size of gworld = middle screen */

RGBForeColor(white);
RGBBackColor(black);
	SetRect(&destRect,0,0,331,266);					/* SIZE of gworld rect */
	NewGWorld( &GlobalGWorld, 0, &destRect, nil , nil, 0 );
	GlobalPixMap = GetGWorldPixMap( GlobalGWorld );	/*  Get the GWorlds Pixmaphandle */
LockPixels( GlobalPixMap );							/*  Lock it down */
}


/********************** SetupRects ******************************/

SetupRects()
{
	SetRect(&gRollerRect,129,87,160,119);		/* castle options */
	SetRect(&gStoreRect,232,188,265,220);	
	SetRect(&gBankRect,100,142,133,172);
	SetRect(&gGuildRect,100,188,133,220);
	SetRect(&gTavernRect,205,87,236,119);
	SetRect(&gHealerRect,235,142,265,172);	
	SetRect(&gdungeonRect,145,130,225,227);
	SetRect(&gTreasureRect,145,150,225,270);
	
  	SetRect(&gCharRect0,359,39,505,63);
	SetRect(&gCharRect1,359,68,505,92);
	SetRect(&gCharRect2,359,97,505,121);
	SetRect(&gCharRect3,359,126,505,150);
	SetRect(&gPartyInfoRect,360,7,502,33);
		
	SetRect(&gDungDispRect,33,34,330,266);
	SetRect(&gMoveRect,115,297,240,317);
	SetRect(&gItemsRect,277,311,355,333);
	SetRect(&gSpellsRect,437,317,491,347);
	SetRect(&gUseRect,217,307,266,326);		
	SetRect(&gStatsRect,364,146,499,332);
	SetRect(&gPanicRect,210,12,264,26);
	SetRect(&gActionRect,100,327,275,357);		
	SetRect(&gConsoleRect,0,0,517,369);	
	
	SetRect(&leftRect,33,33,132,265);	 		/* all main rects 102 px. wide by 235 tall*/
	SetRect(&centerRect,132,33,231,265);
	SetRect(&rightRect,231,33,330,265);
	SetRect(&clwallRect,132,33,165,265);		/* all center rects 34 pixels wide */
	SetRect(&crwallRect,198,33,231,265);
	SetRect(&cRect,165,33,198,265);	
	SetRect(&gChestRect,170,220,202,252);				 	
	SetRect(&gListStatsRect,369,334,427,351);
	SetRect(&gListItemsRect,435,334,493,351);
	 
	SetRect(&gCompassRect,158,299,195,321); 			
}
/********************** ReadFiles ******************************/
ReadFiles()
{

	SFReply		reply;
	Point		myPoint;
	SFTypeList	typeList;
	int			numTypes;
	int			z,dferror;
	long		count;
	short		rc,fRefNum;	
	
	myPoint.h	=100;
	myPoint.v	= 100;
	typeList[0] = 'RJG1';
	numTypes	= 1;
	
	rc=FSOpen("\pGBItems",0,&fRefNum);						/*** ITEMS ***/
	
	dferror=3;										/* Dungeon datafile */
 	if (rc)											/* if ERROR */
		DBErrors(dferror);							/* EXIT */
			
		count = (sizeof(struct ItemInfo)*104);
	 	FSRead ( fRefNum, &count, ((Ptr)GameItems));
		FSClose (fRefNum);
		fRefNum=0;			/* set to invalid # to avoid disk wipe-outs! */
}


/********************** ReadDungeon ******************************/
ReadDungeon()
{

	SFReply		reply;
	Point		myPoint;
	SFTypeList	typeList;
	int			numTypes;
	int			z, dferror;
	long		count;
	short		rc,fRefNum;	
	
	myPoint.h	=100;
	myPoint.v	= 100;
	typeList[0] = 'RJG1';
	numTypes	= 1;
	
	count = (sizeof(struct DungInfo));				/* read level */
	rc=FSOpen("\pDungeon",0,&fRefNum);				/*** DUNGEON ***/
	dferror=1;										/* Dungeon datafile */
 	if (rc)											/* if ERROR */
		DBErrors(dferror);							/* EXIT */
					
		SetFPos ( fRefNum, 1, (count*gLevelCount));		/* set rec # */
	 	FSRead ( fRefNum, &count, ((Ptr)Dungeon));
		FSClose (fRefNum);
	fRefNum=0;			/* set to invalid # to avoid disk wipe-outs! */
}

/**************************** MenuBarInit *****************************/

MenuBarInit()
{
	Handle	myMenuBar;
	
	myMenuBar =   GetNewMBar(BASE_RES_ID);	  /* Menu Index */
	SetMenuBar(myMenuBar);
	gFileMenu  = GetMHandle(FILE_MENU_ID);
	gAppleMenu = GetMHandle(APPLE_MENU_ID);
	gOptionsMenu = GetMHandle(OPTIONS_MENU_ID);
	DrawMenuBar();
}

/********************** HandleEvent ***********************************/

HandleEvent()
{
char			theChar;
GrafPtr			oldPort;
Rect			itemRect,destRect,worldBounds;
int				theTime,secs;
				
	if (gWNEImplemented)
		WaitNextEvent(everyEvent,&gTheEvent,MIN_SLEEP,NIL_MOUSE_REGION);
	else
		{
			SystemTask();
			SndTask();
			GetNextEvent(everyEvent, &gTheEvent);								
		}	
	
	switch (gTheEvent.what)
	{
	 	case updateEvt:							 
				BeginUpdate((WindowPtr)gTheEvent.message);
				if (gPanic==NO)		
					{
					DrawPicture (gConsolePicture,&gConsoleRect);
					if (gInCastle==YES)
 						DrawPicture (gMScreenPicture, &gMScreenRect);
 					else if (gInCastle==NO && gPanic==NO)
						UpdateDV();
					UpdateAll();
					}
					gPanic=NO;
				EndUpdate((WindowPtr)gTheEvent.message);
			break;
	 	case app4Evt:
	 		if (gTheEvent.message & 0x00000001)	/* resume from multi-finder */
	 			{
	 			SetPort(gBackgrndWindow);
	 			FillRect(&(gBackgrndWindow->portRect),black);
	 			SetPort(gGameWindow);
					DrawPicture (gConsolePicture,&gConsoleRect);
					if (gInCastle==YES)
 						DrawPicture (gMScreenPicture, &gMScreenRect);
 					else if (gInCastle==NO)
						UpdateDV();
					UpdateAll();					
				}
			break;	 		 	  
		case nullEvent:
			HandleNull();
			break;
		case mouseDown:
	 		HandleMouseDown();
			break;
		case keyDown:
		case autoKey:
			theChar = gTheEvent.message & charCodeMask;
			if ((gTheEvent.modifiers & cmdKey) != 0)
				HandleMenuChoice(MenuKey(theChar));
			break;
	}
}

/********************** HandleNull ***********************************/

HandleNull()
{
	
}

/********************** HandleMouseDown ******************************/

HandleMouseDown()
{
WindowPtr		whichWindow;
short int		thePart,direction;
long int		menuChoice, windSize;
Rect			destRect,worldBounds;
GWorldPtr		world;
GWorldPtr		MakeGWorld();
Point			mouseLoc;

GetMouse(&mouseLoc);

ClearMessage();	 

	thePart= FindWindow(gTheEvent.where, &whichWindow);
	switch(thePart)
	{
		case inMenuBar:
				menuChoice = MenuSelect(gTheEvent.where);
				HandleMenuChoice(menuChoice);
		 		gPanic=YES;
		 		return;
			break;
		case inSysWindow:
				SystemClick(&gTheEvent, whichWindow);
			break;
		case inContent:
			if (PtInRect(mouseLoc, &gPanicRect))
				{
				Panic();
				return;
				}	
			else if (PtInRect(mouseLoc, &gdungeonRect) && gInCastle==YES)
				{
				EnterDungeon();	
				return;
				}
			else if (PtInRect(mouseLoc, &gTreasureRect) && gInCastle==NO)
				{
				TreasureRoutines();	
				return;
				}	
			else if (PtInRect(mouseLoc, &gStatsRect))
				{
				Items();
				return;
				}
			else if (PtInRect(mouseLoc, &gMoveRect) && gInCastle==NO)		/* in dungeon */
				{
		  		DungeonDriver(mouseLoc);				
				return;
				}
			else if (PtInRect(mouseLoc, &gActionRect))
				{
		  		UserAction(mouseLoc);
				return;
				}	
			else if (PtInRect(mouseLoc, &gCharRect0) && 
		  			gDungParty[0] != 99)
				{
					gWhichChar=0;
					gCurChar=gDungParty[0];
					ButtonUpDown();				/* animate it */
				}
		  	else if (PtInRect(mouseLoc, &gCharRect1) && 
		  			gDungParty[1] != 99)
				{
					gWhichChar=1;
					gCurChar=gDungParty[1];
					ButtonUpDown();				/* animate it */
				}
		  	else if (PtInRect(mouseLoc, &gCharRect2) && 
		  			gDungParty[2] != 99)
				{
					gWhichChar=2;
					gCurChar=gDungParty[2];
					ButtonUpDown();				/* animate it */					
				}
		  	else if (PtInRect(mouseLoc, &gCharRect3) && 
		  			gDungParty[3] != 99)
				{
					gWhichChar=3;
					gCurChar=gDungParty[3];
					ButtonUpDown();				/* animate it */					
				}								
				
				
			gPanic=YES;		/* start copybits here, above subRs cant use it */
			ClearMessage();


		RGBForeColor(white);
		RGBBackColor(black);
			SetRect(&worldBounds,33,33,364,299);				
			SetRect(&destRect,33,33,364,299);	
			world=MakeGWorld(&worldBounds);
			SetRect(&gMScreenRect,0,0,331,266);			
			
	 	CopyIntroBits(world,&gMScreenRect);			/* copy mRect screen */	 		
				
			if (PtInRect(mouseLoc, &gBankRect) && gInCastle==YES)
				MagicStore();
			else if (PtInRect(mouseLoc, &gRollerRect) && gInCastle==YES)
				CastleRoller();			
			else if (PtInRect(mouseLoc, &gStoreRect) && gInCastle==YES)
				TheStore();
			else if (PtInRect(mouseLoc, &gGuildRect) && gInCastle==YES)
				TheGuild();
			else if (PtInRect(mouseLoc, &gHealerRect) && gInCastle==YES)
				TheHealer();
			else if (PtInRect(mouseLoc, &gTavernRect) && gInCastle==YES)
				TheTavern();
			else if (PtInRect(mouseLoc, &gPartyInfoRect))
				PartyInfo();				
			else if (PtInRect(mouseLoc, &gListStatsRect) &&
				gDungParty[0] != 99)
							{
								UpdateStats();
								gDisplay=1;
							}				
			else if (PtInRect(mouseLoc, &gListItemsRect) &&
				gDungParty[0] != 99)
							{
								ListItems();
								gDisplay=0;
							}												  		

			 	RGBForeColor(white);
				RGBBackColor(black);   
		 		CopyWorldBits(world,&gMScreenRect);		/* Update console screen */
		 	DisposeGWorld(world);	
	     SetRect(&gMScreenRect,33,33,331,266);	 		
		 break;		
		}
}
/********************** AboutDialog *****************************/
DoAboutDialog()

{
int			itemType, itemHit,  dialogDone = FALSE; 
Handle		itemHandle;
Rect		itemRect;
gDialogNum	=	400;
		
DoDialog();
	
	while (dialogDone == FALSE)
	{
		ModalDialog(NIL_POINTER, &itemHit);
			switch (itemHit)
			{
				case 1:		/* YES */
					dialogDone = TRUE;
					DisposeDialog(gCastleDialog);
					SetPort(gGameWindow);
					break;
			}
	}
}
/********************** HandleMenuChoice *****************************/

HandleMenuChoice(menuChoice)
long int	menuChoice;

{
	int	theMenu;
	int	theItem;
	
	if (menuChoice!=0)
	{
		theMenu = HiWord(menuChoice);
		theItem = LoWord(menuChoice);
		switch (theMenu)
		{
			case APPLE_MENU_ID:
				HandleAppleChoice(theItem);
				break;
			case FILE_MENU_ID:
				HandleFileChoice(theItem);
				break;
			case OPTIONS_MENU_ID:
				HandleOptionChoice(theItem);
				break;
		}
		HiliteMenu(0);
	}
}

/********************** HandleAppleChoice *****************************/

HandleAppleChoice(theItem)
int	theItem;

{
	Str255		accName;
	int			accNumber;
	short int	itemNumber;
	DialogPtr	AboutDialog;
	Rect		destRect,worldBounds;
	GWorldPtr	world;
	GWorldPtr	MakeGWorld();
	
	gPanic=YES;		/* start copybits here */	
	ClearMessage();
	
	RGBForeColor(white);
	RGBBackColor(black);	
		SetRect(&destRect,0,0,517,369);
		SetRect(&worldBounds,0,0,517,369);		
	world=MakeGWorld(&worldBounds);
 		CopyIntroBits(world,&gConsoleRect);			/* copy console screen */
	
	switch(theItem)
	{
		case ABOUT_ITEM:
 			gSndNum=400;
				PlaySound();		
			DoAboutDialog();			
			break;
		default:
			GetItem(gAppleMenu, theItem, accName);
			accNumber=OpenDeskAcc(accName);
			break;
	}
 	RGBForeColor(white);
	RGBBackColor(black);  
 	CopyWorldBits(world,&gConsoleRect);		/* Update console screen */
 DisposeGWorld(world);		
}

/********************** HandleFileChoice *****************************/

HandleFileChoice(theItem)
int	theItem;
{
Boolean			Stop_Now;
Str255			theText;
Rect			destRect,worldBounds;
GWorldPtr		world;
GWorldPtr		MakeGWorld();

RGBForeColor(white);
	RGBBackColor(black);
		SetRect(&destRect,0,0,517,369);
		SetRect(&worldBounds,0,0,517,369);
	world=MakeGWorld(&worldBounds);
 CopyIntroBits(world,&gConsoleRect);			/* copy mRect screen */

	switch(theItem)
	{
		case OPEN_ITEM:	
			if (OpenGame()!=FALSE)	
			{
				RGBForeColor(white);
				RGBBackColor(black); 
	 			CopyWorldBits(world,&gConsoleRect);		/* Update console screen */
				DisposeGWorld(world);	 		
		 		OpenGameSetup();
		 		return;
		 	}
			break;
		case SAVE_ITEM:
			SaveGame();			
			break;
		case CLOSE_ITEM:	
			if (CloseGame()==FALSE)		/* user cancelled */
				{
				RGBForeColor(white);
				RGBBackColor(black); 
	 			CopyWorldBits(world,&gConsoleRect);		/* Update console screen */
				DisposeGWorld(world);
				gPanic=YES;
				return;
				}	
				ReplotScreen();
			gPanic=NO;
			DisposeGWorld(world);
			return;			
		case QUIT_ITEM:
			AStopSnd(Stop_Now);
			if (ASave==ON)		/* data file opened so save and keep going */
				{
				AutoSave();		/* auto save */
				gDone=TRUE;		/* exit game */				
				break;
				}
			else				/* auto save is OFF */
				{
				   if (CheckSave()==NO)			 /* save dialog window */
						{
						gDone=TRUE;
						break;
						}
					else						  /* user said SAVE game */
						{
							if (SaveGame()==YES)  /* user response was good */
							{
							gDone=TRUE;
							DisposeGWorld(world);			
							return;
							}
						}	
				}
				break;
	}
				RGBForeColor(white);
			RGBBackColor(black); 
	 	CopyWorldBits(world,&gConsoleRect);		/* Update console screen */
	DisposeGWorld(world);	
}

/********************** Mainloop ***********************************/

MainLoop()
{
long		secs;
int			x,z;
unsigned	min,max;
	gDone = FALSE;
	
	gWNEImplemented = (NGetTrapAddress(WNE_TRAP_NUM, ToolTrap)!=
					   NGetTrapAddress(UNIMPL_TRAP_NUM, ToolTrap));
				   
	while(gDone==FALSE)
	{
	if (gInCastle==NO && gTreasure==NO && gItemsOnFloor==NO)		
		{
		if (z==1)	/* checks every other time...will slow down FAST machines */
		{
		if(GetRandomNum(min=0,max=20000)==0)		
			InitEncounter();					/* oops, in encounter! **/
			z=0;
		}
		else
			z=1;
		}
		HandleEvent();
	}
}

/********************** HandleOptionChoice ****************************/
/********************** Set bits for future use ***********************/

HandleOptionChoice(theItem)
int		theItem;
{
	switch(theItem)
	{
	case SOUND_ON_ID:
		if (gSndOn==1)
		{
		CheckItem(gOptionsMenu,theItem,ADD_CHECKMARK);
		gSndOn = 0;
		}
	  else
		{
		CheckItem(gOptionsMenu,theItem,REMOVE_CHECKMARK);
		gSndOn = 1;
		}
		break;
	case SLOWER_ON_ID:
		CheckItem(gOptionsMenu,theItem,ADD_CHECKMARK);
		CheckItem(gOptionsMenu,FASTER_ON_ID,REMOVE_CHECKMARK);		
		gSpeed = 0;
		break;
	case FASTER_ON_ID:
		CheckItem(gOptionsMenu,theItem,ADD_CHECKMARK);
		CheckItem(gOptionsMenu,SLOWER_ON_ID,REMOVE_CHECKMARK);
		gSpeed=1;
		break;				
	case PANIC_ON_ID:
		Panic();
		break;
	}
}
	
/************************* PlaySound ******************************/

PlaySound()
{
Handle	My_snd_Handle;
Boolean	Stop_Prev;

	if (gSndOn==1)		/* no sound wanted, so leave! */
	  return;

		My_snd_Handle = GetResource('snd ', gSndNum);
		ASndPlay(My_snd_Handle,Stop_Prev);

}


/************************ StartGame *************************************/
StartGame()
{
	AdjustMenus();  	
	TheCastle();  
}

/************************ OpenGame *************************************/
OpenGame()
{

	Point		myPoint;
	SFTypeList	typeList;
	int			numTypes;
	int			z,width, height, sWidth, sHeight,h,w,v;
	long		count;
	short		rc,fRefNum;	
	Rect		totalRect, r,screenRect,*boundsPtr;	
	
	/* Centers window  */	
		width=344;
		height=154;
		sWidth=screenBits.bounds.right-screenBits.bounds.left;
		sHeight=screenBits.bounds.bottom-screenBits.bounds.top;
		h=screenBits.bounds.left + ((sWidth-width)/2);
		v=screenBits.bounds.top + ((sHeight-height)/2);

myPoint.h	= h;
myPoint.v	= v;

	typeList[0] = 'RJG2';
	numTypes	= 1;
	
	SFGetFile(myPoint, IGNORED_STRING, NIL_FILE_FILTER, numTypes,
		&typeList, NIL_DIALOG_HOOK, &fileName);
		
	if (fileName.good != TRUE)	/* if user did NOT select file to open, leave */
		return(FALSE);

	ASave=ON;					/* auto save is now ON */		
	FSOpen(fileName.fName,fileName.vRefNum,&fRefNum);	
		count = (sizeof(struct CharInfo)*8);
	 	FSRead ( fRefNum, &count, ((Ptr)GameChars));
		FSClose (fRefNum);
		fRefNum=0;			/* set to invalid # to avoid disk wipe-outs! */
	
    	DisableItem(gFileMenu, OPEN_ITEM);		/* File Menu	*/
    	EnableItem(gFileMenu, CLOSE_ITEM);		/* File Menu	*/ 
    return(TRUE);    	   	
}

/************************ OpenGameSetup *************************************/
OpenGameSetup()
{
int		z,x,y,slot;
Str255	theText;

	gPartyNum=-1;				/* -1 means NO characters */
	gPanic=YES;					/* for screen updating */
	gInCastle=YES;				/* default to in castle */
	gLight=OFF;					/* turn light off */

for (x=0;x<=7;x++)				/* read datafile in & set up dungeon party */
{
	switch (GameChars[x].Pos)	
	{
	case -1:		/* no char in position */
		break;
	case 0:
		gPartyNum++;
		gDungParty[0]=x;
		break;
	case 1:
		gPartyNum++;	
		gDungParty[1]=x;
		break;
	case 2:
		gPartyNum++;	
		gDungParty[2]=x;
		break;
	case 3:
		gPartyNum++;	
		gDungParty[3]=x;
		break;		
	}
	
 /* if (GameChars[x].level>=1)             cheater code   
	{
		GameChars[x].level=30;
		GameChars[x].hits=200;
		GameChars[x].gold=5000;
		 GameChars[x].dmg=0;	
		GenerateSpells(x); 
	}	 */ 	
}

if (GameChars[gDungParty[0]].dngLevel>=0 &&
	gDungParty[0] != 99)								/* check first char for x,y,z loc */
	{
		gDungLevel=0;									/* ALWAYS zero if down */
		gInCastle=NO;		
		gXLoc=GameChars[gDungParty[0]].xLoc;			/* X positon */
		gYLoc=GameChars[gDungParty[0]].yLoc;			/* Y position */
		gLevelCount=GameChars[gDungParty[0]].dngLevel;	/* set gdunglevel  now */
		InitDungeon();				/* new walls? */	
		ReadDungeon();				/* load dungeon into system */
		/* DungeonDriver();			  dungeon driver */
		TorchAndLightOn();	
		UpdateDV();					
	}

if (gDungParty[0] != 99)			/* At LEAST one char in party */
	{
		gCurChar=gDungParty[0];
			gWhichChar=0;
			gDisplay=1;
 		UpdateAll();
	}
}
/************************ CloseGame *************************************/
CloseGame()
{
int			x;

if (ASave==ON)		/* auto save game if on */
		AutoSave();    		
else				/* otherwise,see if user wants to */	
	if (CheckClose()==YES)	/* yes, by all means SAVE game! */
	{
		if (SaveGame()==FALSE)			/* user cancelled */
			return (FALSE);
	}

for (x=0;x<=gPartyNum;x++)	/* now zero out chars */
	{
		gCurChar=gDungParty[x];
		gWhichChar=x;			
		ClearStats();
	}
	ASave=OFF;								/* double check AutoSave is off */
   	EnableItem(gFileMenu, OPEN_ITEM);		/* File Menu	*/
   	DisableItem(gFileMenu, CLOSE_ITEM);		/* File Menu	*/   		
	VarInit();
	ResetParty();
	
    DisableItem(gFileMenu, CLOSE_ITEM);		/* File Menu	*/     				
 }
/************************ SaveGame *************************************/
SaveGame()
{

Point		myPoint;
short		rc,fRefNum;
int			z,width, height, sWidth, sHeight,h,w,v;
long		count;
SFReply		reply;
FInfo		fndrInfo;
OSType		fdType;
OSType		fdCreator;
Rect		totalRect, r,screenRect,*boundsPtr;

	/* Centers window  */	
		width=344;
		height=154;
		sWidth=screenBits.bounds.right-screenBits.bounds.left;
		sHeight=screenBits.bounds.bottom-screenBits.bounds.top;
		h=screenBits.bounds.left + ((sWidth-width)/2);
		v=screenBits.bounds.top + ((sHeight-height)/2);

myPoint.h	= h;
myPoint.v	= v;

if (ASave==YES)		/* auto save is on, so go to AutoSave instead! */
	{
		AutoSave();
		return;
	}
	
	SFPutFile (myPoint, "\pSave Game as:", 
		"\pGBGame", NIL_FILE_FILTER, &fileName);

if (reply.good==3)	/* user CANCELLED */
	return(NO);			/* so RETURN to playing! */
			 	
Create (fileName.fName, 0, 'RJGB', 'RJG2');
	if (fileName.good)
		FSOpen(fileName.fName,fileName.vRefNum,&fRefNum);
	else
		return(NO);		/* DON'T WRITE TO FILE */
	
	ASave=ON;			/* auto save is now ON */
	
/* now write data to file */
	count = (sizeof(struct CharInfo)*8);
	 	FSWrite ( fRefNum,&count, ((Ptr)GameChars));
		fndrInfo.fdType='RJG2';		/* set file creator type */
		fndrInfo.fdCreator='RJGB';	
		fndrInfo.fdFlags=fHasBundle;	
		SetFInfo (fileName.fName,0, &fndrInfo );	 	
		FSClose (fRefNum);
		fRefNum=0;			/* set to invalid # to avoid disk wipe-outs! */
	return(YES);
}

/************************ AutoSave *************************************/
AutoSave()
{

Point		myPoint;
short		rc,fRefNum;
int			z;
long		count;

myPoint.h	=100;
myPoint.v	= 100;

if (ASave==OFF)		/* if auto save is OFF then RETURN!! */
	return;
	
	Create (fileName.fName, 0, 'RJGB', 'WHTS');
	if (fileName.good)
		FSOpen(fileName.fName,fileName.vRefNum,&fRefNum);
	else
		return;
		
/* now write data to file */
	count = (sizeof(struct CharInfo)*8);
	 	FSWrite ( fRefNum,&count, ((Ptr)GameChars));
		FSClose (fRefNum);
		fRefNum=0;				 /* set to invalid # to avoid disk wipe-outs! */

}

/************************** GameWindow ******************************/

GameWindow()
{
int				yy,xx,width, height, sWidth, sHeight,h,w,v;
Rect			totalRect, r,screenRect,*boundsPtr;

RGBForeColor(white);
RGBBackColor(black);

	gConsolePicture = GetPicture(GAME_WINDOW);	
		gGameWindow=GetNewCWindow(GAME_WINDOW,NIL_POINTER,MOVE_TO_FRONT);
		
	/* CENTERS WINDOW */	
		r=gGameWindow->portRect;		
		width=r.right - r.left;
		height=r.bottom - r.top;
		sWidth=screenBits.bounds.right-screenBits.bounds.left;
		sHeight=screenBits.bounds.bottom-screenBits.bounds.top;
		h=screenBits.bounds.left + ((sWidth-width)/2);
		v=screenBits.bounds.top + ((sHeight-height)/2)+10;

	MoveWindow(gGameWindow,h,v,FALSE);
	SelectWindow(gGameWindow);		
		
			ShowWindow(gGameWindow);
		 		SetPort(gGameWindow);
			DrawPicture (gConsolePicture,&gConsoleRect);
		gMScreenPicture = GetPicture(402);	
	SetRect(&gMScreenRect,33,33,331,266);	
 	DisposeWindow(gIntroWindow);
ReleaseResource(gIntroPic);		/* free up memory */	
}

/************************ AdjustMenus ****************************/

AdjustMenus()
{
	EnableItem(gSpecialMenu,0);				/* Special Menu	*/	
	EnableItem(gOptionsMenu, 0);			/* Options Menu	*/
	EnableItem(gFileMenu, SAVE_ITEM);		/* File Menu	*/	
   	DisableItem(gFileMenu, CLOSE_ITEM);		/* File Menu	*/ 	
	DrawMenuBar();
}

/************************ UpdateStats ****************************/

UpdateStats()
{
Str255		text;
int			count,damage,w,x,y,z;

	ClearBStats();	
	UpdateName();	
	
	RGBBackColor(&gNameBack);		/* set bckgrnd color */
 	TextMode(0);

RGBForeColor(&gSpecName);	 		/* Update stats-area */
  	x = 368;y = 177;MoveTo(x,y); DrawString("\p");	
  		MoveTo(x,y); DrawString(GameChars[gCurChar].name);
  		x = 368;y = 192; MoveTo(x,y); DrawString("\p");	  
  	x = 368;y = 192;	
MoveTo(x,y);										/* race */
    	if (GameChars[gCurChar].race==0)		
				DrawString("\pOrc - ");
		  else if (GameChars[gCurChar].race==1)
				DrawString("\pGnome - ");
		  else if (GameChars[gCurChar].race==2)
				DrawString("\pElf - ");
		  else if (GameChars[gCurChar].race==3)
				DrawString("\pDwarf - ");
		  else if (GameChars[gCurChar].race==4)
				DrawString("\pOgre - ");
	
		if (GameChars[gCurChar].type==0)				/* type */
				DrawString("\pQueer");
		else if (GameChars[gCurChar].type==1)
				DrawString("\pDrag Queen");
		else if (GameChars[gCurChar].type==2)
				DrawString("\pMuse");
		else if (GameChars[gCurChar].type==3)
				DrawString("\pGuppie");
		else if (GameChars[gCurChar].type==4)
				DrawString("\pLesbian");
		else if (GameChars[gCurChar].type==5)
				DrawString("\pMaster");
				
		RGBForeColor(&gNormName);	/* set frgcolor color to blue*/		
   		x = 368;y = 195;
		MoveTo(x,y+16);											/* stats */
			NumToString(GameChars[gCurChar].hits,text);
			DrawString("\pHts: ");
		RGBForeColor(&gStatsFore);	/* set frgcolor color to l.blue*/			
		MoveTo(x+28,y+16);					
			DrawString(text);

		RGBForeColor(&gNormName);				
			MoveTo(x,y+32);
				NumToString(GameChars[gCurChar].level,text);
				DrawString("\pLvl: ");
		RGBForeColor(&gStatsFore);	/* set frgcolor color to l.blue*/				
			MoveTo(x+28,y+32);				
				DrawString(text);
				
		RGBForeColor(&gNormName);					
			MoveTo(x,y+48);
				NumToString(GameChars[gCurChar].str,text);
				DrawString("\pStr: ");
		RGBForeColor(&gStatsFore);	/* set frgcolor color to l.blue*/								
			MoveTo(x+28,y+48);				
				DrawString(text);
				
		RGBForeColor(&gNormName);						
			MoveTo(x,y+64);			
				NumToString(GameChars[gCurChar].con,text);
				DrawString("\pCon: ");
				RGBForeColor(&gStatsFore);	/* set frgcolor color to l.blue*/			
			MoveTo(x+28,y+64);				
				DrawString(text);
				
		RGBForeColor(&gNormName);				
			MoveTo(x,y+82);			
				DrawString("\pExp: ");
		RGBForeColor(&gStatsFore);	/* set frgcolor color to l.blue*/								
			MoveTo(x+28,y+82);	
			if (GameChars[gCurChar].exp<32000)
				{
				NumToString(GameChars[gCurChar].exp,text);						
				DrawString(text);
				}
			else
				DrawString("\p*****");
				
		RGBForeColor(&gNormName);				
			MoveTo(x,y+98);			
				DrawString("\pGld: ");
		RGBForeColor(&gStatsFore);	/* set frgcolor color to l.blue*/								
			MoveTo(x+28,y+98);
			if (GameChars[gCurChar].gold<32000)
				{
				NumToString(GameChars[gCurChar].gold,text);						
				DrawString(text);
				}
			else
				DrawString("\p*****");			
				
		RGBForeColor(&gNormName);				
			MoveTo(x+64,y+16);			
				NumToString(GameChars[gCurChar].wis,text);
				DrawString("\pWis:");
		RGBForeColor(&gStatsFore);	/* set frgcolor color to l.blue*/				
			MoveTo(x+92,y+16);				
				DrawString(text);
				
		RGBForeColor(&gNormName);								
			MoveTo(x+64,y+32);			
				NumToString(GameChars[gCurChar].itl,text);
				DrawString("\pInt: ");
		RGBForeColor(&gStatsFore);	/* set frgcolor color to l.blue*/								
			MoveTo(x+92,y+32);				
				DrawString(text);
				
		RGBForeColor(&gNormName);				
			MoveTo(x+64,y+48);			
				NumToString(GameChars[gCurChar].dex,text);
				DrawString("\pDex: ");
		RGBForeColor(&gStatsFore);	/* set frgcolor color to l.blue*/								
			MoveTo(x+92,y+48);				
				DrawString(text);
				
		RGBForeColor(&gNormName);
			MoveTo(x+64,y+64);			
				NumToString(GameChars[gCurChar].age,text);
				DrawString("\pAge: ");
		RGBForeColor(&gStatsFore);	/* set frgcolor color to l.blue*/								
			MoveTo(x+92,y+64);				
				DrawString(text);
				
		RGBForeColor(&gNormName);					
			MoveTo(x,y+116);	
				DrawString("\pMSpells:");	
			MoveTo(x+53,y+114);	
			RGBForeColor(&gSpecName);	/* set frgcolor color to red*/							
					NumToString(GameChars[gCurChar].mspells[0],text);
				DrawString(text);
			RGBForeColor(&gNormName);				
				DrawString("\p|");
					NumToString(GameChars[gCurChar].mspells[1],text);
			RGBForeColor(&gSpecName);	/* set frgcolor color to red*/					
				DrawString(text);
			RGBForeColor(&gNormName);				
				DrawString("\p|");	
					NumToString(GameChars[gCurChar].mspells[2],text);
			RGBForeColor(&gSpecName);	/* set frgcolor color to red*/						
				DrawString(text);
			RGBForeColor(&gNormName);				
				DrawString("\p|");
			RGBForeColor(&gSpecName);	/* set frgcolor color to red*/										
					NumToString(GameChars[gCurChar].mspells[3],text);
				DrawString(text);
				
			RGBForeColor(&gNormName);								
			MoveTo(x,y+132);	
				DrawString("\pCSpells:");
			MoveTo(x+53,y+130);
			RGBForeColor(&gSpecName);	/* set frgcolor color to red*/										
					NumToString(GameChars[gCurChar].cspells[0],text);
				DrawString(text);
			RGBForeColor(&gNormName);					
				DrawString("\p|");
				
			RGBForeColor(&gSpecName);	/* set frgcolor color to red*/					
					NumToString(GameChars[gCurChar].cspells[1],text);
				DrawString(text);
			RGBForeColor(&gNormName);						
				DrawString("\p|");
			RGBForeColor(&gSpecName);	/* set frgcolor color to red*/							
					NumToString(GameChars[gCurChar].cspells[2],text);
				DrawString(text);

			RGBForeColor(&gNormName);			
				DrawString("\p|");
			RGBForeColor(&gSpecName);	/* set frgcolor color to red*/										
					NumToString(GameChars[gCurChar].cspells[3],text);
				DrawString(text);
}

/************************ UpdateButton ****************************/

UpdateButton()
{
Str255		text;
int			count,damage,w,x,y,z;


	ClearBStats();	

	RGBBackColor(&gNameBack);		/* set bckgrnd color */
 	TextMode(0);

RGBForeColor(&gSpecName);	 		/* Update stats-area */
  	x = 368;y = 177;MoveTo(x,y); DrawString("\p");	
  		MoveTo(x,y); DrawString(GameChars[gCurChar].name);
  		x = 368;y = 192; MoveTo(x,y); DrawString("\p");	  
  	x = 368;y = 192;	
MoveTo(x,y);										/* race */
    	if (GameChars[gCurChar].race==0)		
				DrawString("\pOrc - ");
		  else if (GameChars[gCurChar].race==1)
				DrawString("\pGnome - ");
		  else if (GameChars[gCurChar].race==2)
				DrawString("\pElf - ");
		  else if (GameChars[gCurChar].race==3)
				DrawString("\pDwarf - ");
		  else if (GameChars[gCurChar].race==4)
				DrawString("\pOgre - ");
	
		if (GameChars[gCurChar].type==0)				/* type */
				DrawString("\pQueer");
		else if (GameChars[gCurChar].type==1)
				DrawString("\pDrag Queen");
		else if (GameChars[gCurChar].type==2)
				DrawString("\pMuse");
		else if (GameChars[gCurChar].type==3)
				DrawString("\pGuppie");
		else if (GameChars[gCurChar].type==4)
				DrawString("\pLesbian");
		else if (GameChars[gCurChar].type==5)
				DrawString("\pMaster");
				
		RGBForeColor(&gNormName);	/* set frgcolor color to blue*/		
   		x = 368;y = 195;
		MoveTo(x,y+16);											/* stats */
			NumToString(GameChars[gCurChar].hits,text);
			DrawString("\pHts: ");
		RGBForeColor(&gStatsFore);	/* set frgcolor color to l.blue*/			
		MoveTo(x+28,y+16);					
			DrawString(text);

		RGBForeColor(&gNormName);				
			MoveTo(x,y+32);
				NumToString(GameChars[gCurChar].level,text);
				DrawString("\pLvl: ");
		RGBForeColor(&gStatsFore);	/* set frgcolor color to l.blue*/				
			MoveTo(x+28,y+32);				
				DrawString(text);
				
		RGBForeColor(&gNormName);					
			MoveTo(x,y+48);
				NumToString(GameChars[gCurChar].str,text);
				DrawString("\pStr: ");
		RGBForeColor(&gStatsFore);	/* set frgcolor color to l.blue*/								
			MoveTo(x+28,y+48);				
				DrawString(text);
				
		RGBForeColor(&gNormName);						
			MoveTo(x,y+64);			
				NumToString(GameChars[gCurChar].con,text);
				DrawString("\pCon: ");
				RGBForeColor(&gStatsFore);	/* set frgcolor color to l.blue*/			
			MoveTo(x+28,y+64);				
				DrawString(text);
				
		RGBForeColor(&gNormName);				
			MoveTo(x,y+82);			
				DrawString("\pExp: ");
		RGBForeColor(&gStatsFore);	/* set frgcolor color to l.blue*/								
			MoveTo(x+28,y+82);	
			if (GameChars[gCurChar].exp<32000)
				{
				NumToString(GameChars[gCurChar].exp,text);						
				DrawString(text);
				}
			else
				DrawString("\p*****");
				
		RGBForeColor(&gNormName);				
			MoveTo(x,y+98);			
				DrawString("\pGld: ");
		RGBForeColor(&gStatsFore);	/* set frgcolor color to l.blue*/								
			MoveTo(x+28,y+98);
			if (GameChars[gCurChar].gold<32000)
				{
				NumToString(GameChars[gCurChar].gold,text);						
				DrawString(text);
				}
			else
				DrawString("\p*****");			
				
		RGBForeColor(&gNormName);				
			MoveTo(x+64,y+16);			
				NumToString(GameChars[gCurChar].wis,text);
				DrawString("\pWis:");
		RGBForeColor(&gStatsFore);	/* set frgcolor color to l.blue*/				
			MoveTo(x+92,y+16);				
				DrawString(text);
				
		RGBForeColor(&gNormName);								
			MoveTo(x+64,y+32);			
				NumToString(GameChars[gCurChar].itl,text);
				DrawString("\pInt: ");
		RGBForeColor(&gStatsFore);	/* set frgcolor color to l.blue*/								
			MoveTo(x+92,y+32);				
				DrawString(text);
				
		RGBForeColor(&gNormName);				
			MoveTo(x+64,y+48);			
				NumToString(GameChars[gCurChar].dex,text);
				DrawString("\pDex: ");
		RGBForeColor(&gStatsFore);	/* set frgcolor color to l.blue*/								
			MoveTo(x+92,y+48);				
				DrawString(text);
				
		RGBForeColor(&gNormName);
			MoveTo(x+64,y+64);			
				NumToString(GameChars[gCurChar].age,text);
				DrawString("\pAge: ");
		RGBForeColor(&gStatsFore);	/* set frgcolor color to l.blue*/								
			MoveTo(x+92,y+64);				
				DrawString(text);
				
		RGBForeColor(&gNormName);					
			MoveTo(x,y+116);	
				DrawString("\pMSpells:");	
			MoveTo(x+53,y+114);	
			RGBForeColor(&gSpecName);	/* set frgcolor color to red*/							
					NumToString(GameChars[gCurChar].mspells[0],text);
				DrawString(text);
			RGBForeColor(&gNormName);				
				DrawString("\p|");
					NumToString(GameChars[gCurChar].mspells[1],text);
			RGBForeColor(&gSpecName);	/* set frgcolor color to red*/					
				DrawString(text);
			RGBForeColor(&gNormName);				
				DrawString("\p|");	
					NumToString(GameChars[gCurChar].mspells[2],text);
			RGBForeColor(&gSpecName);	/* set frgcolor color to red*/						
				DrawString(text);
			RGBForeColor(&gNormName);				
				DrawString("\p|");
			RGBForeColor(&gSpecName);	/* set frgcolor color to red*/										
					NumToString(GameChars[gCurChar].mspells[3],text);
				DrawString(text);
				
			RGBForeColor(&gNormName);								
			MoveTo(x,y+132);	
				DrawString("\pCSpells:");
			MoveTo(x+53,y+130);
			RGBForeColor(&gSpecName);	/* set frgcolor color to red*/										
					NumToString(GameChars[gCurChar].cspells[0],text);
				DrawString(text);
			RGBForeColor(&gNormName);					
				DrawString("\p|");
				
			RGBForeColor(&gSpecName);	/* set frgcolor color to red*/					
					NumToString(GameChars[gCurChar].cspells[1],text);
				DrawString(text);
			RGBForeColor(&gNormName);						
				DrawString("\p|");
			RGBForeColor(&gSpecName);	/* set frgcolor color to red*/							
					NumToString(GameChars[gCurChar].cspells[2],text);
				DrawString(text);

			RGBForeColor(&gNormName);			
				DrawString("\p|");
			RGBForeColor(&gSpecName);	/* set frgcolor color to red*/										
					NumToString(GameChars[gCurChar].cspells[3],text);
				DrawString(text);
}


/************************ UpdateName ****************************/

UpdateName()

{
Str255		damage,hits,text;
int			count,w,x,y,z;

	SetPort(gGameWindow);								
	RGBForeColor(&gNormName);			/* set frgcolor color to blue*/		
	RGBBackColor(&gNameBack);			/* set bckgrnd color */
	TextMode(0);
	
  x = 368;y = 56;
switch(gWhichChar)				
{
	case 0:
	 	MoveTo(x,y);DrawString("\p");
		MoveTo(x,y);
		DrawString(GameChars[gCurChar].name); 
		MoveTo(x+78,y);		
		UpdateName2();  
	break; 
	case 1:	
		MoveTo(x,y+29);DrawString("\p");
		MoveTo(x,y+29);
		DrawString(GameChars[gCurChar].name);	
		MoveTo(x+78,y+29);
		UpdateName2();
	break; 	
	case 2:				 
		MoveTo(x,y+58);DrawString("\p");
		MoveTo(x,y+58);
		DrawString(GameChars[gCurChar].name);		
		MoveTo(x+78,y+58);
		UpdateName2();
	break; 	
	case 3:			 
		MoveTo(x,y+87);DrawString("\p");
		MoveTo(x,y+87);
		DrawString(GameChars[gCurChar].name);		
		MoveTo(x+78,y+87);
		UpdateName2();
	break; 	
	}
}				

/************************ UpdateName2 ****************************/

UpdateName2()
{
Str255		hits, damage;

		if (GameChars[gCurChar].status==DEAD)
			{
			RGBForeColor(&gSpecName);
				DrawString("\pDEAD");
			RGBForeColor(&gNormName);
			return;		
			}
		else if (GameChars[gCurChar].status==PERMDEAD)
			{
			RGBForeColor(&gSpecName);
				DrawString("\pPERM");
			RGBForeColor(&gNormName);
			return;		
			}
		else if (GameChars[gCurChar].status==POISONED)
			{
			RGBForeColor(&gSpecName);
			NumToString(GameChars[gCurChar].hits,hits);
				NumToString(GameChars[gCurChar].hits-GameChars[gCurChar].dmg,damage);
				DrawString(hits);DrawString("\p/");
			DrawString(damage);
			RGBForeColor(&gNormName);
			}						
		else 
			{
			NumToString(GameChars[gCurChar].hits,hits);
			NumToString(GameChars[gCurChar].hits-GameChars[gCurChar].dmg,damage);
			if (GameChars[gCurChar].hits<=99)
				DrawString("\p");
			if (GameChars[gCurChar].hits<=9)
				DrawString("\p");				
			DrawString(hits);
			DrawString("\p/");
			DrawString(damage);
			}
}			
/************************ ClearStats ****************************/

ClearStats()

{

Str255		text;
int			x,y;
								 
  RGBBackColor(&gNameBack);		/* set bckgrnd color */
	TextMode(0);
   	  x = 368;y = 56;

switch(gWhichChar)				
{
	case 0:
		MoveTo(x,y);
		DrawString("\p");
	break; 
	case 1:
		MoveTo(x,y+29);
		DrawString("\p");
	break; 	
	case 2:			 
		MoveTo(x,y+58);
		DrawString("\p");
	break; 	
	case 3:		 
		MoveTo(x,y+87);
		DrawString("\p");
	break;
}		
 x = 368;y = 177;		
	RGBBackColor(&gStatsBack);	
	  MoveTo(x,y);							/* move to x,y loc */
	  DrawString("\p");
	MoveTo(378,y);
		DrawString("\p");	/* clear old information */
ClearBStats();								/* paint stats gray */
}

/*************************     TheCastle      *********************/

TheCastle()
{
int		x,z;
Str255	theText;

	gInCastle = YES;
	gTreasure=NO;

for (z=0;z<=gPartyNum;z++)			/** turn all items in use OFF  **/
	{	
	 for (x=0;x<=6;x++)
	 {
		if (GameItems[GameChars[gDungParty[z]].itemsInUse[x]].type==TORCH)
			{
			GameChars[gDungParty[z]].itemsInUse[x]=OPENSLOT;
			gLight=OFF;
			}
			
	  } 
	if (GameChars[gDungParty[z]].status>=2 &&
		 GameChars[gDungParty[z]].status!=99)	/* if char there, then do spells */
			GenerateSpells(z);		/* z = current char */
	}

AllSpellsOff();	

gLightSpell=OFF;
gLight=OFF;		
for (x=0;x<=gPartyNum;x++)  	/* for castle datafile info */
	GameChars[gDungParty[x]].dngLevel=-1;	/* set to Castle */

gLevelCount=0;					/* set to castle */		

}

/************************ UpdateAll ****************************/

UpdateAll()
{
int	z,tempChar,temp2Char;

tempChar=gCurChar;			/* don't lose our place on screen */
temp2Char=gWhichChar;

	 	for (z=gPartyNum;z>=0;z--)				
	 	{
	 	gWhichChar=z;
 		gCurChar=gDungParty[z];
 			if (gCurChar!=99 && gCurChar!=tempChar)		  /* update if char there */
 				UpdateName();
  			else if (gCurChar!=99 && gCurChar==tempChar)  /* update if char there */
 				{
 				UpdateName();
 				if (gDisplay==1)
 					UpdateStats();
 				else
 					ListItems();
 				}				
 			else
 				ClearStats();
 		}
	gCurChar=tempChar;		/* set back to original place */
	gWhichChar=temp2Char;
 }

/************************ DoDialog ****************************/

DoDialog()
{
int				yy,xx,width, height, sWidth, sHeight,h,w,v;
Rect			totalRect, r,screenRect,*boundsPtr;

	gCastleDialog=GetNewDialog(gDialogNum, NIL_POINTER, MOVE_TO_FRONT);	
		
	/* Positions dialog window  */	
		r=gCastleDialog->portRect;		
		width=r.right - r.left;
		height=r.bottom - r.top;
		sWidth=screenBits.bounds.right-screenBits.bounds.left;
		sHeight=screenBits.bounds.bottom-screenBits.bounds.top;
		h=screenBits.bounds.left + ((sWidth-width)/2);
		v=screenBits.bounds.top + ((sHeight-height)/2)+10;

	MoveWindow(gCastleDialog,h-76,v-32,FALSE);
	SelectWindow(gCastleDialog);	

		ShowWindow(gCastleDialog);
	SetPort(gCastleDialog);
}

/************************ ClearBStats ****************************/
ClearBStats()
{
Rect	ClearRect;

SetRect(&ClearRect,366,179,499,336);

	SetPort(gGameWindow);
		RGBForeColor(&gStatsBack);
		PaintRect(&ClearRect);
	RGBForeColor(&gNormName);
}

/************************ LightOff ****************************/
LightOff()
{
 if (gInCastle==YES)
 	return;
 else
	RGBForeColor(&gBlack);
		PaintRect(&gMScreenRect);	/* set to black, no light initially */
	gLight=OFF; 
}
/************************ EnterDungeon ****************************/

EnterDungeon()			/** ENTER THE DUNGEON ONLY **/
{

int			itemType, dungeon_id, itemHit,x, dialogDone = FALSE,
			allowedIn=NO; 
Handle		itemHandle;
Rect		itemRect;
Str255		theText;
Rect		openDoorRect;
CIconHandle	openDoor;
dungeon_id	=	412;

if (gDungParty[0]==99)			/* no char, then go away! */
{
	ClearMessage();
		DrawString("\pThe Dungeon is closed for repairs.");
	return;
}

for (x=0;x<=gPartyNum;x++)		/* if ONLY dead chars in party */
	{
	if (GameChars[gDungParty[x]].status>=2 && GameChars[gDungParty[x]].status<99)
		{
		allowedIn=YES;
		break;
		}
	}
	
if (allowedIn==NO)
	{
	ClearMessage();
		DrawString("\pYou can't enter the dungeon right now");
	return;
	}

SetRect(&openDoorRect,164,145,202,199);
openDoor=GetCIcon(192);
PlotCIcon(&openDoorRect,openDoor);
DisposeCIcon(openDoor);

	ClearMessage();   
	DrawString("\pTake heed, brave adventurer!");
	Pause();Pause();
		
	gDungLevel=0;
	gLevelCount=0;		/* first level ... 0 = level 1 of dungeon */
	InitDungeon();		/* init. walls */
	ReadDungeon();	
		gView=0;			/* set view to north */
		gXLoc=4;gYLoc=1;	/* set starting position */ 	
	gInCastle=NO;	
	Pause();

	
	if (gLight==OFF && gLightSpell==OFF)
		{
		LightOff();
		TorchMessage();
		}
	else
		UpdateDV();	
}
/************************ InitDungeon ****************************/

InitDungeon()			/** ROUTINE INITS THE DUNGEON ONLY **/
{

int			itemType, dungeon_id, itemHit,x, dialogDone = FALSE,
			allowedIn=NO; 
Handle		itemHandle;
Rect		itemRect;
Str255		theText;
short	rsrcFileNum;
dungeon_id	=	412;

DisposHandle ( gLeftWall );				/* release memory of whatever was there */
DisposHandle ( gRightWall);	
DisposHandle ( gLeftDoor);		 		 	 
DisposHandle ( gRightDoor);
DisposHandle ( gFlatWall);
DisposHandle ( gFlatDoor);		
DisposHandle ( gOpenSpace);
DisposHandle ( gFarWall);
DisposHandle ( gCLWall);	
DisposHandle ( gCRWall);	
DisposHandle ( gCOpenSpace);
DisposHandle ( gCLDoor);	
DisposHandle ( gCRDoor);
DisposHandle ( gCFWall);
DisposHandle ( gCFDoor);
DisposHandle ( gFarDoor);
		
rsrcFileNum=OpenResFile("\pGBW.data");	/*  open PICT resource file */	
	if (ResError())
		{
			ParamText("\pThere is a problem with file 'GBW.data'.",0,0,0);
				NoteAlert(6000,NIL_POINTER);
			ExitToShell();
		}	
		
if (gLevelCount<=5)						/* open up lower level walls */
{			 		 
	gLeftWall 	= GetPicture(130);		 		 	 
	gRightWall  = GetPicture(129);	
	gLeftDoor	= GetPicture(140);		 		 	 
	gRightDoor 	= GetPicture(141);
	gFlatWall	= GetPicture(131);
	gFlatDoor	= GetPicture(133);		
	gOpenSpace	= GetPicture(142);
	gFarWall	= GetPicture(135);
	gCLWall		= GetPicture(136);	
	gCRWall		= GetPicture(137);	
	gCOpenSpace	= GetPicture(138);
	gCLDoor		= GetPicture(139);	
	gCRDoor		= GetPicture(132);
	gCFWall		= GetPicture(144);
	gCFDoor		= GetPicture(143);
	gFarDoor	= GetPicture(134);
}
else if (gLevelCount>=2)						/* open up lower level walls */
{			 		 
	gLeftWall 	= GetPicture(146);		 		 	 
	gRightWall  = GetPicture(145);	
	gLeftDoor	= GetPicture(156);		 		 	 
	gRightDoor 	= GetPicture(157);
	gFlatWall	= GetPicture(147);
	gFlatDoor	= GetPicture(149);		
	gOpenSpace	= GetPicture(158);
	gFarWall	= GetPicture(151);
	gCLWall		= GetPicture(152);	
	gCRWall		= GetPicture(153);	
	gCOpenSpace	= GetPicture(154);
	gCLDoor		= GetPicture(155);	
	gCRDoor		= GetPicture(148);
	gCFWall		= GetPicture(160);
	gCFDoor		= GetPicture(159);
	gFarDoor	= GetPicture(150);
}
	DetachResource( gLeftWall);		 		 	 
	DetachResource(	gRightWall);	
	DetachResource(	gLeftDoor);		 		 	 
	DetachResource(	gRightDoor);
	DetachResource(	gFlatWall);
	DetachResource(	gFlatDoor);		
	DetachResource(	gOpenSpace);
	DetachResource(	gFarWall);
	DetachResource(	gCLWall);	
	DetachResource(	gCRWall);	
	DetachResource(	gCOpenSpace);
	DetachResource(	gCLDoor);	
	DetachResource(	gCRDoor);
	DetachResource(	gCFWall);
	DetachResource(	gCFDoor);
	DetachResource(	gFarDoor);	

 CloseResFile(rsrcFileNum);	 /* now close resource file */							

}

/*************************** DungeonDriver ****************************/
DungeonDriver(mouseLoc)	
Point		mouseLoc;
					 /** MAIN DUNGEON MOVE ROUTINE **/
{			
Rect		forward, backward, left, right;
int			z,x;
unsigned	min,max;

if (gInEncounter==YES)
	return;

gTreasure=NO;					/* not interested in the treasure, so move on */
	for (z=0;z<=2;z++)			/* found items to 0 */
		gFoundItems[z]=-1;	
	gItemsOnFloor=NO;
		
SetRect(&forward,160,297,190,317);
	SetRect(&backward,86,308,134,323);
	SetRect(&left,115,297,155,317);
SetRect(&right,200,297,240,317);

	if (PtInRect(mouseLoc, &forward))			/* FORWARD */
		MoveForward();		
	else if (PtInRect(mouseLoc, &left)) 			/* LEFT */
		{
		if (gView-1<0)		 
			gView=3;
		else
			gView--;
		}
	else if (PtInRect(mouseLoc, &right)) 		/* RIGHT */
		{
		if (gView+1>3)
			gView=0;
		else
			gView++;
		}
		
	else if (gInCastle==YES)				/* don't replot if in castle */
		{
			ClearMessage();
			DrawString("\pWelcome to the Castle");	
			return;		
		}

if(GetRandomNum(min=0,max=2)==0)			/* footsteps */
	gSndNum=12644;
else
	gSndNum=20374;
PlaySound();
		
	PlotCompass();	/* plots direction button */
		
/***** DUNGEON CONTROL ROUTINES BELOW  *****/	
z=0;
if (Dungeon[gDungLevel].SA[Dungeon[gDungLevel].XY[gXLoc][gYLoc]]==250)	
	{
	for (x=0;x<=6;x++)
	{
		if (GameChars[x].bank==99) /* game already won don't show wizard */
			z=-1;
	}
	if (z!=-1)						/* go to Wiz.Chamber if okay */
		{
		WizardChamber();			/* succeeded in releasing wizard! */
		return;
		}
	}
	
CheckTorch();					/* see if torch has burned out */					

UpdateDV();						/*  Main dungeon view updater */
	CheckRoomAttrib();			/*  In a special room??  Do it */
		
CheckPoisonedChars();			/* check for any poisoned chars */
	
if (CheckPartyStatus()==YES)	/* if ENTIRE party is dead, then reset it */
	PartyDead();
/* else
	UpdateAllNames();			  Updates all name info (in case of poisoning, etc. */			

if (gInCastle==NO)				/* if not in castle check encounter */
	CheckForEncounter();		/*  check encounter */
		/** NOTE!!! CheckForEncounter SHOULD BE LAST, 
			DUE TO PARTY DAMAGE UPDATES...DO NOT PUT ANY
			ADDITIONAL ROUTINES (except the one below) AFTER THIS! **/
			
for (x=0;x<=gPartyNum;x++)		/* for dungeon datafile info */
{			
	GameChars[gDungParty[x]].xLoc=gXLoc;
	GameChars[gDungParty[x]].yLoc=gYLoc;
 	
	if (gInCastle==YES)
		GameChars[gDungParty[x]].dngLevel=-1;			/* accurate dng. DB (0=level 1)  */
	else
		GameChars[gDungParty[x]].dngLevel=gLevelCount;	/* accurate dng. DB (0=level 1) */
}	
}

/************************ CheckRoomAttrib ****************************/
CheckRoomAttrib()				/*  check room attributes */
{	
unsigned		min,max;
int				z;

/*** STAIRS UP  ***/									
if (Dungeon[gDungLevel].SA[Dungeon[gDungLevel].XY[gXLoc][gYLoc]]==99)
	{
	StairUp();					/* go use stairs, <0 if now in castle */
		if (gInCastle==YES)		/* go to Castle  */
			{
				TheCastle();
	 			DrawPicture (gMScreenPicture, &gMScreenRect);
	 			ReplotChar();
			}
		else
			UpdateDV();
		gPanic=YES;		/* panic used for screen updating ONLY!! */
	}
/*** STAIRS DOWN ***/	
else if (Dungeon[gDungLevel].SA[Dungeon[gDungLevel].XY[gXLoc][gYLoc]]==101)
	StairDown();
	
/*** TRAP - EXTINGUISH ALL SPELLS & TORCH USE ***/	
else if (Dungeon[gDungLevel].SA[Dungeon[gDungLevel].XY[gXLoc][gYLoc]]==13)
	ExtinguishTrap();

/*** TRAP -TELEPORTER! ***/	
else if (Dungeon[gDungLevel].SA[Dungeon[gDungLevel].XY[gXLoc][gYLoc]]==11)
	{
	ClearMessage();
		DrawString("\pYou've been teleported!");
			if (gLevelCount>=12)
				gLevelCount=1;		/* special t's for level 13 */
			gLevelCount=GetRandomNum(min=gLevelCount,max=gLevelCount+4);
			if (gLevelCount>=12)
				gLevelCount=12;		/* safety check for t'ing */
			InitDungeon();
		ReadDungeon();
	UpdateDV();
	}	
else if (Dungeon[gDungLevel].SA[Dungeon[gDungLevel].XY[gXLoc][gYLoc]]==5)	
	{
	ClearMessage();
			DrawString("\pYou hit a trap!");
			Pause();Pause();	
				z=GetRandomNum(min=0,max=gPartyNum);
					GameChars[gDungParty[z]].status=3;		/* POISONED! */
				ClearMessage();
			DrawString(GameChars[gDungParty[z]].name);
		DrawString("\p has been poisoned in a trap!");
 		gSndNum=16878; 		 	
			PlaySound();
		Pause();Pause();					
	}
}	

/************************ MoveForward ****************************/
MoveForward()
{

int		tempChar,tempWhere;		/*  used for updating purposes only */

/**** moving/viewing northward ****/
if (gView==0 && Dungeon[gDungLevel].N[Dungeon[gDungLevel].XY[gXLoc][gYLoc]]==1
	|| gView==0 && Dungeon[gDungLevel].N[Dungeon[gDungLevel].XY[gXLoc][gYLoc]]==2)			/* viewing North */
		gYLoc=gYLoc-1;

else if (gView==0 && Dungeon[gDungLevel].N[Dungeon[gDungLevel].XY[gXLoc][gYLoc]]==0)
	HitWall();
	
/**** moving/viewing eastward ****/	
else if (gView==1 && Dungeon[gDungLevel].E[Dungeon[gDungLevel].XY[gXLoc][gYLoc]]==1
	|| gView==1 && Dungeon[gDungLevel].E[Dungeon[gDungLevel].XY[gXLoc][gYLoc]]==2)			/* viewing North */
		gXLoc=gXLoc+1;

else if (gView==1 && Dungeon[gDungLevel].E[Dungeon[gDungLevel].XY[gXLoc][gYLoc]]==0)
		HitWall();
		
/**** moving/viewing southward ****/
else if (gView==2 && Dungeon[gDungLevel].S[Dungeon[gDungLevel].XY[gXLoc][gYLoc]]==1
	|| gView==2 && Dungeon[gDungLevel].S[Dungeon[gDungLevel].XY[gXLoc][gYLoc]]==2)			/* viewing North */
		gYLoc=gYLoc+1;

else if (gView==2 && Dungeon[gDungLevel].S[Dungeon[gDungLevel].XY[gXLoc][gYLoc]]==0)
		HitWall();
		
/**** moving/viewing westward ****/
else if (gView==3 && Dungeon[gDungLevel].W[Dungeon[gDungLevel].XY[gXLoc][gYLoc]]==1
	|| gView==3 && Dungeon[gDungLevel].W[Dungeon[gDungLevel].XY[gXLoc][gYLoc]]==2)			/* viewing North */
		gXLoc=gXLoc-1;
	
else if (gView==3 && Dungeon[gDungLevel].W[Dungeon[gDungLevel].XY[gXLoc][gYLoc]]==0)
		HitWall();
}

/************************ HitWall ****************************/
HitWall()
{
int			tempChar,x,y,tempWhichChar;

	
gSndNum=25565;			/* smacking sound */
	PlaySound();
	
	ClearMessage();	
		DrawString(GameChars[gDungParty[0]].name);DrawString("\p hit a wall!");
		GameChars[gDungParty[0]].dmg++;
	RGBBackColor(&gStatsBack);
	
if (GameChars[gDungParty[0]].dmg>=GameChars[gDungParty[0]].hits)
	{
	GameChars[gDungParty[0]].status=DEAD;  	/* DEAD */
	DeadChar();							/* TURN OFF ALL ITEMS, SORT PARTY, ETC. */
	UpdateAllNames();
	}
else									/* UPDATE DAMAGE FOR FIRST CHAR */
	{
	tempChar=gCurChar;
		tempWhichChar=gWhichChar;
		gCurChar=gDungParty[0];
			gWhichChar=0;
			UpdateName();
		gCurChar=tempChar;
	gWhichChar=tempWhichChar;
	}
  UpdateDV();		
}

/************************ UpdateDV ****************************/
UpdateDV()
{

int			itemType, dungeon_id, wallType,  dialogDone = FALSE; 
Handle		itemHandle;
Rect		sourceRect,destRect;
CGrafPtr	currentPort;		/* Port used before switching to the gworld's. */
GDHandle	currentDevice;		/* GDevice used before switching to the gworld's. */

if (gInCastle==YES)				/* if in castle, then don't do anything */
{
 	DrawPicture (gMScreenPicture, &gMScreenRect);
	return;
}


RGBForeColor(white);			/* set default colors */
RGBBackColor(black);

GetGWorld(&currentPort,&currentDevice);	
	SetRect(&sourceRect,33,33,330,265);			/* only copy dung. coords */
SetRect(&destRect,33,33,330,265);				/* to this spot on screen */					

SetGWorld(GlobalGWorld, NIL_POINTER);			/* set to GLOBAL gworld */

UpdateDV2();									/* now plot dungeon in gworld */

RGBForeColor(white);
	RGBBackColor(black);
		SetGWorld(currentPort,currentDevice);	/* set back to screen */	
	CopyBits (&(((GrafPtr) GlobalGWorld)->portBits), 	/* copy new scene to screen */	
&(*gGameWindow).portBits, &sourceRect, &destRect,0, nil );
	
}

/************************ UpdateDV2 ****************************/

UpdateDV2()
{

int			itemType, dungeon_id, wallType,  dialogDone = FALSE; 
Handle		itemHandle;


if (gLight==NO && gLightSpell==OFF)		/* light is off */
	{
	LightOff();
	return;
	}	
if (gView==0)		/* northern view */
	{
/* LEFT Rect  */
	wallType=Dungeon[gDungLevel].W[Dungeon[gDungLevel].XY[gXLoc][gYLoc]];
		switch (wallType)
		{
			case 0:		/*** SOLID WALL ***/
				DrawPicture (gLeftWall,&leftRect);
				break;
			case 1:		/*** DOORWAY ***/
				DrawPicture(gLeftDoor,&leftRect);
				break;
			case 2:		/*** OPEN ***/
		 		if (Dungeon[gDungLevel].N[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc]]==0)
					DrawPicture(gFlatWall,&leftRect);
				else if (Dungeon[gDungLevel].N[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc]]==1)
					DrawPicture(gFlatDoor,&leftRect);		 	
				if (Dungeon[gDungLevel].N[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc]]==2)
				{	 	
					if (Dungeon[gDungLevel].N[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc-1]]==0)
			 		DrawPicture (gFarWall,&leftRect);	
			 		else if (Dungeon[gDungLevel].N[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc-1]]==1)
			 		DrawPicture (gFarDoor,&leftRect);	 
			 		else if (Dungeon[gDungLevel].N[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc-1]]==2)
			 		DrawPicture (gOpenSpace,&leftRect); 		 		
				}
				break;
		}
		
 /* RIGHT Rect  */
		wallType=Dungeon[gDungLevel].E[Dungeon[gDungLevel].XY[gXLoc][gYLoc]];
		switch (wallType)
		{
			case 0:		/*** SOLID WALL ***/
				DrawPicture (gRightWall,&rightRect);
				break;
			case 1:		/*** DOORWAY  ***/
				DrawPicture (gRightDoor,&rightRect);
				break;	
			case 2:		/*** OPEN ***/
				if (Dungeon[gDungLevel].N[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc]]==0)
					DrawPicture(gFlatWall,&rightRect);
				else if (Dungeon[gDungLevel].N[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc]]==1)
					DrawPicture(gFlatDoor,&rightRect);		 	
				else if (Dungeon[gDungLevel].N[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc]]==2)
				{	 	
		 			if (Dungeon[gDungLevel].N[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc-1]]==0)
			 		DrawPicture (gFarWall,&rightRect);	 
					else if (Dungeon[gDungLevel].N[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc-1]]==1)
			 		DrawPicture (gFarDoor,&rightRect);	 
			 		if (Dungeon[gDungLevel].N[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc-1]]==2)
			 		DrawPicture (gOpenSpace,&rightRect); 		 		
				}
				break;
		}		
		
/* CENTER Rect  */		
	wallType=Dungeon[gDungLevel].N[Dungeon[gDungLevel].XY[gXLoc][gYLoc]];
		switch (wallType)
		{
			case 0:		/*** SOLID WALL ***/
				DrawPicture (gFlatWall,&centerRect);
				break;
			case 1:		/*** DOORWAY ***/
				DrawPicture(gFlatDoor,&centerRect);
				break;
			case 2:		/*** OPEN ***/
				if (Dungeon[gDungLevel].W[Dungeon[gDungLevel].XY[gXLoc][gYLoc-1]]==0)
			 		DrawPicture (gCLWall,&clwallRect);
				else if (Dungeon[gDungLevel].W[Dungeon[gDungLevel].XY[gXLoc][gYLoc-1]]==1)
			 		DrawPicture (gCLDoor,&clwallRect);
				else if (Dungeon[gDungLevel].W[Dungeon[gDungLevel].XY[gXLoc][gYLoc-1]]==2)
					{
						if (Dungeon[gDungLevel].N[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc-1]]==0)
				 			DrawPicture (gCFWall,&clwallRect);	 			 		
						else if (Dungeon[gDungLevel].N[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc-1]]==1)
				 			DrawPicture (gCFDoor,&clwallRect);
						else if (Dungeon[gDungLevel].N[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc-1]]==2)
				 			DrawPicture (gCOpenSpace,&clwallRect);
				 	}
				 	
				if (Dungeon[gDungLevel].N[Dungeon[gDungLevel].XY[gXLoc][gYLoc-1]]==0)
			 		DrawPicture (gCFWall,&cRect);
		 		else if (Dungeon[gDungLevel].N[Dungeon[gDungLevel].XY[gXLoc][gYLoc-1]]==1)
			 		DrawPicture (gCFDoor,&cRect);  
		 		else if (Dungeon[gDungLevel].N[Dungeon[gDungLevel].XY[gXLoc][gYLoc-1]]==2)
			 		DrawPicture (gCOpenSpace,&cRect); 	 	
				 			 			
				if (Dungeon[gDungLevel].E[Dungeon[gDungLevel].XY[gXLoc][gYLoc-1]]==0)
			 		DrawPicture (gCRWall,&crwallRect);	
				else if (Dungeon[gDungLevel].E[Dungeon[gDungLevel].XY[gXLoc][gYLoc-1]]==1)
			 		DrawPicture (gCRDoor,&crwallRect);
				else if (Dungeon[gDungLevel].E[Dungeon[gDungLevel].XY[gXLoc][gYLoc-1]]==2)
					{
						if (Dungeon[gDungLevel].N[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc-1]]==0)
					 		DrawPicture (gCFWall,&crwallRect);	 			 		
						else if (Dungeon[gDungLevel].N[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc-1]]==1)
					 		DrawPicture (gCFDoor,&crwallRect);
						else if (Dungeon[gDungLevel].N[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc-1]]==2)
					 		DrawPicture (gCOpenSpace,&crwallRect);
				 	}	 		
				break;
		}
	}
	
if (gView==2)		/* southern view */
	{
/* LEFT Rect  */
	wallType=Dungeon[gDungLevel].E[Dungeon[gDungLevel].XY[gXLoc][gYLoc]];
		switch (wallType)
		{
			case 0:		/*** SOLID WALL ***/
				DrawPicture (gLeftWall,&leftRect);
				break;
			case 1:		/*** DOORWAY ***/
				DrawPicture(gLeftDoor,&leftRect);
				break;
			case 2:		/*** OPEN ***/
		 		if (Dungeon[gDungLevel].S[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc]]==0)
					DrawPicture(gFlatWall,&leftRect);
				else if (Dungeon[gDungLevel].S[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc]]==1)
					DrawPicture(gFlatDoor,&leftRect);		 	
				if (Dungeon[gDungLevel].S[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc]]==2)
				{	 	
					if (Dungeon[gDungLevel].S[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc+1]]==0)
			 		DrawPicture (gFarWall,&leftRect);	
			 		/* else if (Dungeon[gDungLevel].S[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc+1]]==1)
			 		DrawPicture (gFarDoor,&leftRect);	*/ 
			 		else if (Dungeon[gDungLevel].S[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc+1]]==2)
			 		DrawPicture (gOpenSpace,&leftRect); 		 		
				}
				break;
		}
		
 /* RIGHT Rect  */
		wallType=Dungeon[gDungLevel].W[Dungeon[gDungLevel].XY[gXLoc][gYLoc]];
		switch (wallType)
		{
			case 0:		/*** SOLID WALL ***/
				DrawPicture (gRightWall,&rightRect);
				break;
			case 1:		/*** DOORWAY  ***/
				DrawPicture (gRightDoor,&rightRect);
				break;	
			case 2:		/*** OPEN ***/
				if (Dungeon[gDungLevel].S[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc]]==0)
					DrawPicture(gFlatWall,&rightRect);
				else if (Dungeon[gDungLevel].S[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc]]==1)
					DrawPicture(gFlatDoor,&rightRect);		 	
				else if (Dungeon[gDungLevel].S[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc]]==2)
				{	 	
		 			if (Dungeon[gDungLevel].S[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc+1]]==0)
			 		DrawPicture (gFarWall,&rightRect);	 
				   else if (Dungeon[gDungLevel].S[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc+1]]==1)
			 		DrawPicture (gFarDoor,&rightRect);	
			 		if (Dungeon[gDungLevel].S[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc+1]]==2)
			 		DrawPicture (gOpenSpace,&rightRect); 		 		
				}
				break;
		}		
		
/* CENTER Rect  */		
	wallType=Dungeon[gDungLevel].S[Dungeon[gDungLevel].XY[gXLoc][gYLoc]];
		switch (wallType)
		{
			case 0:		/*** SOLID WALL ***/
				DrawPicture (gFlatWall,&centerRect);
				break;
			case 1:		/*** DOORWAY ***/
				DrawPicture(gFlatDoor,&centerRect);
				break;
			case 2:		/*** OPEN ***/
				if (Dungeon[gDungLevel].E[Dungeon[gDungLevel].XY[gXLoc][gYLoc+1]]==0)
			 		DrawPicture (gCLWall,&clwallRect);
				else if (Dungeon[gDungLevel].E[Dungeon[gDungLevel].XY[gXLoc][gYLoc+1]]==1)
			 		DrawPicture (gCLDoor,&clwallRect);
				else if (Dungeon[gDungLevel].E[Dungeon[gDungLevel].XY[gXLoc][gYLoc+1]]==2)
					{
						if (Dungeon[gDungLevel].S[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc+1]]==0)
				 			DrawPicture (gCFWall,&clwallRect);	 			 		
						if (Dungeon[gDungLevel].S[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc+1]]==1)
				 			DrawPicture (gCFDoor,&clwallRect);
						if (Dungeon[gDungLevel].S[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc+1]]==2)
				 			DrawPicture (gCOpenSpace,&clwallRect);
				 	}
				 	
				if (Dungeon[gDungLevel].S[Dungeon[gDungLevel].XY[gXLoc][gYLoc+1]]==0)
			 		DrawPicture (gCFWall,&cRect);
		 		else if (Dungeon[gDungLevel].S[Dungeon[gDungLevel].XY[gXLoc][gYLoc+1]]==1)
			 		DrawPicture (gCFDoor,&cRect);  
		 		else if (Dungeon[gDungLevel].S[Dungeon[gDungLevel].XY[gXLoc][gYLoc+1]]==2)
			 		DrawPicture (gCOpenSpace,&cRect); 	 	
				 			 			
				if (Dungeon[gDungLevel].W[Dungeon[gDungLevel].XY[gXLoc][gYLoc+1]]==0)
			 		DrawPicture (gCRWall,&crwallRect);	
				else if (Dungeon[gDungLevel].W[Dungeon[gDungLevel].XY[gXLoc][gYLoc+1]]==1)
			 		DrawPicture (gCRDoor,&crwallRect);
				else if (Dungeon[gDungLevel].W[Dungeon[gDungLevel].XY[gXLoc][gYLoc+1]]==2)
					{
						if (Dungeon[gDungLevel].S[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc+1]]==0)
					 		DrawPicture (gCFWall,&crwallRect);	 			 		
						else if (Dungeon[gDungLevel].S[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc+1]]==1)
					 		DrawPicture (gCFDoor,&crwallRect);
						else if (Dungeon[gDungLevel].S[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc+1]]==2)
					 		DrawPicture (gCOpenSpace,&crwallRect);
				 	}	 		
				break;
		}
	}
if (gView==1)		/* eastern view */
	{
/* LEFT Rect  */
	wallType=Dungeon[gDungLevel].N[Dungeon[gDungLevel].XY[gXLoc][gYLoc]];
		switch (wallType)
		{
			case 0:		/*** SOLID WALL ***/
				DrawPicture (gLeftWall,&leftRect);
				break;
			case 1:		/*** DOORWAY ***/
				DrawPicture(gLeftDoor,&leftRect);
				break;
			case 2:		/*** OPEN ***/
		 		if (Dungeon[gDungLevel].E[Dungeon[gDungLevel].XY[gXLoc][gYLoc-1]]==0)
					DrawPicture(gFlatWall,&leftRect);
				else if (Dungeon[gDungLevel].E[Dungeon[gDungLevel].XY[gXLoc][gYLoc-1]]==1)
					DrawPicture(gFlatDoor,&leftRect);		 	
				if (Dungeon[gDungLevel].E[Dungeon[gDungLevel].XY[gXLoc][gYLoc-1]]==2)
				{	 	
					if (Dungeon[gDungLevel].E[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc-1]]==0)
			 		DrawPicture (gFarWall,&leftRect);	
			 		else if (Dungeon[gDungLevel].E[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc-1]]==1)
			 		DrawPicture (gFarDoor,&leftRect);	 
			 		else if (Dungeon[gDungLevel].E[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc-1]]==2)
			 		DrawPicture (gOpenSpace,&leftRect); 		 		
				}
				break;
		}
		
 /* RIGHT Rect  */
		wallType=Dungeon[gDungLevel].S[Dungeon[gDungLevel].XY[gXLoc][gYLoc]];
		switch (wallType)
		{
			case 0:		/*** SOLID WALL ***/
				DrawPicture (gRightWall,&rightRect);
				break;
			case 1:		/*** DOORWAY  ***/
				DrawPicture (gRightDoor,&rightRect);
				break;	
			case 2:		/*** OPEN ***/
		 		if (Dungeon[gDungLevel].E[Dungeon[gDungLevel].XY[gXLoc][gYLoc+1]]==0)
					DrawPicture(gFlatWall,&rightRect);
				else if (Dungeon[gDungLevel].E[Dungeon[gDungLevel].XY[gXLoc][gYLoc+1]]==1)
					DrawPicture(gFlatDoor,&rightRect);		 	
				if (Dungeon[gDungLevel].E[Dungeon[gDungLevel].XY[gXLoc][gYLoc+1]]==2)
				{	 	
					if (Dungeon[gDungLevel].E[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc+1]]==0)
			 		DrawPicture (gFarWall,&rightRect);	
			 		else if (Dungeon[gDungLevel].E[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc+1]]==1)
			 		DrawPicture (gFarDoor,&rightRect);	 
			 		else if (Dungeon[gDungLevel].E[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc+1]]==2)
			 		DrawPicture (gOpenSpace,&rightRect); 		 		
				}
				break;
		}		
		
/* CENTER Rect  */		
	wallType=Dungeon[gDungLevel].E[Dungeon[gDungLevel].XY[gXLoc][gYLoc]];
		switch (wallType)
		{
			case 0:		/*** SOLID WALL ***/
				DrawPicture (gFlatWall,&centerRect);
				break;
			case 1:		/*** DOORWAY ***/
				DrawPicture(gFlatDoor,&centerRect);
				break;
			case 2:		/*** OPEN ***/
				if (Dungeon[gDungLevel].N[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc]]==0)
			 		DrawPicture (gCLWall,&clwallRect);
				if (Dungeon[gDungLevel].N[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc]]==1)
			 		DrawPicture (gCLDoor,&clwallRect);
				if (Dungeon[gDungLevel].N[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc]]==2)
					{
						if (Dungeon[gDungLevel].E[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc-1]]==0)
				 			DrawPicture (gCFWall,&clwallRect);	 			 		
						else if (Dungeon[gDungLevel].E[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc-1]]==1)
				 			DrawPicture (gCFDoor,&clwallRect);
						else if (Dungeon[gDungLevel].E[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc-1]]==2)
				 			DrawPicture (gCOpenSpace,&clwallRect);
				 	}
				 	
				if (Dungeon[gDungLevel].E[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc]]==0)
			 		DrawPicture (gCFWall,&cRect);
		 		else if (Dungeon[gDungLevel].E[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc]]==1)
			 		DrawPicture (gCFDoor,&cRect);  
		 		else if (Dungeon[gDungLevel].E[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc]]==2)
			 		DrawPicture (gCOpenSpace,&cRect); 	 	
				 			 			
				if (Dungeon[gDungLevel].S[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc]]==0)
			 		DrawPicture (gCRWall,&crwallRect);	
				else if (Dungeon[gDungLevel].S[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc]]==1)
			 		DrawPicture (gCRDoor,&crwallRect);
				else if (Dungeon[gDungLevel].S[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc]]==2)
					{
						if (Dungeon[gDungLevel].E[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc+1]]==0)
					 		DrawPicture (gCFWall,&crwallRect);	 			 		
						else if (Dungeon[gDungLevel].E[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc+1]]==1)
					 		DrawPicture (gCFDoor,&crwallRect);
						else if (Dungeon[gDungLevel].E[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc+1]]==2)
					 		DrawPicture (gCOpenSpace,&crwallRect);
				 	}	 		
				break;
		}
	}
	
else if (gView==3)		/** western view **/ 
	{
/* LEFT Rect  */
	wallType=Dungeon[gDungLevel].S[Dungeon[gDungLevel].XY[gXLoc][gYLoc]];
		switch (wallType)
		{
			case 0:		/*** SOLID WALL ***/
				DrawPicture (gLeftWall,&leftRect);
				break;
			case 1:		/*** DOORWAY ***/
				DrawPicture(gLeftDoor,&leftRect);
				break;		
			case 2:		/*** OPEN ***/
		 		if (Dungeon[gDungLevel].W[Dungeon[gDungLevel].XY[gXLoc][gYLoc+1]]==0)
					DrawPicture(gFlatWall,&leftRect);
				else if (Dungeon[gDungLevel].W[Dungeon[gDungLevel].XY[gXLoc][gYLoc+1]]==1)
					DrawPicture(gFlatDoor,&leftRect);		 	
				if (Dungeon[gDungLevel].W[Dungeon[gDungLevel].XY[gXLoc][gYLoc+1]]==2)
				{	 	
					if (Dungeon[gDungLevel].W[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc+1]]==0)
			 		DrawPicture (gFarWall,&leftRect);	
			 		else if (Dungeon[gDungLevel].W[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc+1]]==1)
			 		DrawPicture (gFarDoor,&leftRect);	 
			 		else if (Dungeon[gDungLevel].W[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc+1]]==2)
			 		DrawPicture (gOpenSpace,&leftRect); 		 		
				}
				break;
		}
		
 /* RIGHT Rect  */
		wallType=Dungeon[gDungLevel].N[Dungeon[gDungLevel].XY[gXLoc][gYLoc]];
		switch (wallType)
		{
			case 0:		/*** SOLID WALL ***/
				DrawPicture (gRightWall,&rightRect);
				break;
			case 1:		/*** DOORWAY  ***/
				DrawPicture (gRightDoor,&rightRect);
				break;	
			case 2:		/*** OPEN ***/
		 		if (Dungeon[gDungLevel].W[Dungeon[gDungLevel].XY[gXLoc][gYLoc-1]]==0)
					DrawPicture(gFlatWall,&rightRect);
				else if (Dungeon[gDungLevel].W[Dungeon[gDungLevel].XY[gXLoc][gYLoc-1]]==1)
					DrawPicture(gFlatDoor,&rightRect);		 	
				if (Dungeon[gDungLevel].W[Dungeon[gDungLevel].XY[gXLoc][gYLoc-1]]==2)
				{	 	
					if (Dungeon[gDungLevel].W[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc-1]]==0)
			 		DrawPicture (gFarWall,&rightRect);	
			 		else if (Dungeon[gDungLevel].W[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc-1]]==1)
			 		DrawPicture (gFarDoor,&rightRect);	 
			 		else if (Dungeon[gDungLevel].W[Dungeon[gDungLevel].XY[gXLoc+1][gYLoc-1]]==2)
			 		DrawPicture (gOpenSpace,&rightRect); 		 		
				}
				break;
		}		
		
/* CENTER Rect  */		
	wallType=Dungeon[gDungLevel].W[Dungeon[gDungLevel].XY[gXLoc][gYLoc]];
		switch (wallType)
		{
			case 0:		/*** SOLID WALL ***/
				DrawPicture (gFlatWall,&centerRect);
				break;
			case 1:		/*** DOORWAY ***/
				DrawPicture(gFlatDoor,&centerRect);
				break;				
			case 2:		/*** OPEN ***/			
				if (Dungeon[gDungLevel].S[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc]]==0)
			 		DrawPicture (gCLWall,&clwallRect);
				if (Dungeon[gDungLevel].S[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc]]==1)
			 		DrawPicture (gCLDoor,&clwallRect);
				if (Dungeon[gDungLevel].S[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc]]==2)
					{
						if (Dungeon[gDungLevel].W[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc+1]]==0)
				 			DrawPicture (gCFWall,&clwallRect);	 			 		
						else if (Dungeon[gDungLevel].W[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc+1]]==1)
				 			DrawPicture (gCFDoor,&clwallRect);
						else if (Dungeon[gDungLevel].W[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc+1]]==2)
				 			DrawPicture (gCOpenSpace,&clwallRect);
				 	}
				 	
				if (Dungeon[gDungLevel].W[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc]]==0)
			 		DrawPicture (gCFWall,&cRect);
		 		else if (Dungeon[gDungLevel].W[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc]]==1)
			 		DrawPicture (gCFDoor,&cRect);  
		 		else if (Dungeon[gDungLevel].W[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc]]==2)
			 		DrawPicture (gCOpenSpace,&cRect); 	 	
				 			 			
				if (Dungeon[gDungLevel].N[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc]]==0)
			 		DrawPicture (gCRWall,&crwallRect);	
				else if (Dungeon[gDungLevel].N[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc]]==1)
			 		DrawPicture (gCRDoor,&crwallRect);
				else if (Dungeon[gDungLevel].N[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc]]==2)
					{
						if (Dungeon[gDungLevel].W[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc-1]]==0)
					 		DrawPicture (gCFWall,&crwallRect);	 			 		
						else if (Dungeon[gDungLevel].W[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc-1]]==1)
					 		DrawPicture (gCFDoor,&crwallRect);
						else if (Dungeon[gDungLevel].W[Dungeon[gDungLevel].XY[gXLoc-1][gYLoc-1]]==2)
					 		DrawPicture (gCOpenSpace,&crwallRect);
				 	}	 		
				break;
		}
	}
	if (gTreasure==YES)
	{
		PlotChest();
		gTreasure=YES;
	}	
}


